/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.binding;

import info.bix.tokai.bixpp.binding.Base64Header;
import info.bix.tokai.bixpp.binding.HexHeader;
import info.bix.tokai.bixpp.binding.Link;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class Image
implements Serializable {
    private static final long serialVersionUID = -6882867512556260407L;
    private Link _link;
    private HexHeader _hexHeader;
    private Base64Header _base64Header;

    public Image() {
    }

    public Base64Header getBase64Header() {
        return this._base64Header;
    }

    public HexHeader getHexHeader() {
        return this._hexHeader;
    }

    public Link getLink() {
        return this._link;
    }

    public void setBase64Header(Base64Header base64Header) {
        this._base64Header = base64Header;
        this._link = null;
        this._hexHeader = null;
    }

    public void setHexHeader(HexHeader hexHeader) {
        this._hexHeader = hexHeader;
        this._link = null;
        this._base64Header = null;
    }

    public void setLink(Link link) {
        this._link = link;
        this._base64Header = null;
        this._hexHeader = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.awt.Image getImage() {
        if (this._base64Header != null) {
            ByteArrayInputStream imageInputStream = new ByteArrayInputStream(this._base64Header.getBase64());
            try {
                BufferedImage bufferedImage = ImageIO.read(imageInputStream);
                return bufferedImage;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)imageInputStream);
            }
            IOUtils.closeQuietly((InputStream)imageInputStream);
            return null;
        }
        if (this._hexHeader != null) {
            ByteArrayInputStream imageInputStream = new ByteArrayInputStream(this._hexHeader.getHex());
            try {
                BufferedImage bufferedImage = ImageIO.read(imageInputStream);
                return bufferedImage;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)imageInputStream);
            }
            IOUtils.closeQuietly((InputStream)imageInputStream);
            return null;
        }
        if (this._link == null) return null;
        if (this._link.getURI() == null) return null;
        try {
            return ImageIO.read(this._link.getURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Image(Link link) {
        this();
        this.setLink(link);
    }

    public Image(Base64Header base64Header) {
        this();
        this.setBase64Header(base64Header);
    }

    public Image(HexHeader hexHeader) {
        this();
        this.setHexHeader(hexHeader);
    }
}

