/*
 * Decompiled with CFR 0.152.
 */
package com.mindprod.csv;

import java.io.PrintWriter;
import java.io.Writer;

public class CSVWriter {
    private static final String lineSeparator = "\r\n";
    static final boolean DEBUGGING = false;
    private char quote;
    private final boolean trim;
    private PrintWriter pw;
    private int quoteLevel;
    private char separator;
    private boolean wasPreviousField = false;

    public void close() {
        if (this.pw != null) {
            this.pw.close();
            this.pw = null;
        }
    }

    public void nl() {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVWriter");
        }
        this.pw.write(lineSeparator);
        this.wasPreviousField = false;
    }

    public void put(String s) {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVWriter");
        }
        if (s == null) {
            this.nl();
            return;
        }
        if (this.wasPreviousField) {
            this.pw.write(this.separator);
        }
        if (this.trim) {
            s = s.trim();
        }
        if (s.indexOf(this.quote) >= 0) {
            this.pw.write(this.quote);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == this.quote) {
                    this.pw.write(this.quote);
                    this.pw.write(this.quote);
                    continue;
                }
                this.pw.write(c);
            }
            this.pw.write(this.quote);
        } else if (this.quoteLevel == 2 || this.quoteLevel == 1 && s.indexOf(32) >= 0 || s.indexOf(this.separator) >= 0) {
            this.pw.write(this.quote);
            this.pw.write(s);
            this.pw.write(this.quote);
        } else {
            this.pw.write(s);
        }
        this.wasPreviousField = true;
    }

    public CSVWriter(Writer pw) {
        this(pw, 1, ',', '\"', true);
    }

    public CSVWriter(Writer pw, int quoteLevel, char separator, char quote, boolean trim) {
        this.pw = pw instanceof PrintWriter ? (PrintWriter)pw : new PrintWriter(pw);
        if (this.pw == null) {
            throw new IllegalArgumentException("invalid Writer");
        }
        this.quoteLevel = quoteLevel;
        this.separator = separator;
        this.quote = quote;
        this.trim = trim;
    }

    public static void main(String[] args) {
    }
}

