/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.types.XSListJ2;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class CollectionInfoJ2
extends CollectionInfo {
    public CollectionInfoJ2(XSType contentType, String name, String elementName) {
        super(contentType, name, elementName);
        this.setSchemaType(new XSListJ2(contentType));
        this.xsList = (XSListJ2)this.getSchemaType();
    }

    public void generateInitializerCode(JSourceCode jsc) {
        jsc.add(this.getName());
        jsc.append(" = new ArrayList();");
    }

    public void createAccessMethods(JClass jClass) {
        JMethod method = null;
        JType jType = this.getContentType().getJType();
        JParameter contentParam = new JParameter(jType, this.getContentName());
        Object jsc = null;
        String cName = JavaNaming.toJavaClassName(this.getElementName());
        method = new JMethod(null, "add" + cName);
        jClass.addMethod(method);
        method.addException(SGTypes.IndexOutOfBoundsException);
        method.addParameter(contentParam);
        this.createAddMethod(method);
        method = new JMethod(null, "add" + cName);
        jClass.addMethod(method);
        method.addException(SGTypes.IndexOutOfBoundsException);
        method.addParameter(new JParameter(JType.Int, "index"));
        method.addParameter(contentParam);
        this.createAddInsertMethod(method);
        method = new JMethod(jType, "get" + cName);
        jClass.addMethod(method);
        method.addException(SGTypes.IndexOutOfBoundsException);
        method.addParameter(new JParameter(JType.Int, "index"));
        this.createGetByIndexMethod(method);
        method = new JMethod(jType.createArray(), "get" + cName);
        jClass.addMethod(method);
        this.createGetMethod(method);
        if (this.extraMethods()) {
            String suffix = this.getReferenceMethodSuffix();
            method = new JMethod(SGTypes.ArrayList, "get" + cName + suffix);
            jClass.addMethod(method);
            this.createGetCollectionReferenceMethod(method);
        }
        method = new JMethod(null, "set" + cName);
        jClass.addMethod(method);
        method.addException(SGTypes.IndexOutOfBoundsException);
        method.addParameter(new JParameter(JType.Int, "index"));
        method.addParameter(contentParam);
        this.createSetByIndexMethod(method);
        JType arrayType = contentParam.getType().createArray();
        String pName = JavaNaming.toJavaMemberName(cName);
        JParameter arrayParam = new JParameter(arrayType, pName + "Array");
        method = new JMethod(null, "set" + cName);
        method.addParameter(arrayParam);
        jClass.addMethod(method);
        this.createSetArrayMethod(method);
        if (this.extraMethods()) {
            JParameter vParam = new JParameter(SGTypes.ArrayList, pName + "Collection");
            method = new JMethod(null, "set" + cName);
            method.addParameter(vParam);
            jClass.addMethod(method);
            this.createSetCollectionMethod(method);
            String suffix = this.getReferenceMethodSuffix();
            method = new JMethod(null, "set" + cName + suffix);
            method.addParameter(vParam);
            jClass.addMethod(method);
            this.createSetCollectionReferenceMethod(method);
        }
        method = new JMethod(SGTypes.Enumeration, "enumerate" + cName);
        jClass.addMethod(method);
        this.createEnumerateMethod(method);
        method = new JMethod(JType.Int, "get" + cName + "Count");
        jClass.addMethod(method);
        this.createGetCountMethod(method);
        method = new JMethod(JType.Boolean, "remove" + cName);
        method.addParameter(contentParam);
        this.createRemoveMethod(method);
        jClass.addMethod(method);
        method = new JMethod(null, "clear" + cName);
        this.createClearMethod(method);
        jClass.addMethod(method);
    }

    public void createAddMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize > 0) {
            jsc.add("if (!(");
            jsc.append(this.getName());
            jsc.append(".size() < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException();");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".add(");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createAddInsertMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize > 0) {
            jsc.add("if (!(");
            jsc.append(this.getName());
            jsc.append(".size() < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException();");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".add(index, ");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createEnumerateMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("return new org.exolab.castor.util.IteratorEnumeration(");
        jsc.append(this.getName());
        jsc.append(".iterator());");
    }

    public void createGetMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("int size = ");
        jsc.append(this.getName());
        jsc.append(".size();");
        String variableName = this.getName() + ".get(index)";
        JType compType = jType.getComponentType();
        jsc.add(compType.toString());
        jsc.append("[] mArray = new ");
        if (compType.isArray()) {
            jsc.append(compType.getComponentType().toString());
        } else {
            jsc.append(compType.toString());
        }
        jsc.append("[size]");
        if (compType.isArray()) {
            jsc.append("[]");
        }
        jsc.append(";");
        jsc.add("for (int index = 0; index < size; index++) {");
        jsc.indent();
        jsc.add("mArray[index] = ");
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.getName());
            jsc.append(") ");
            jsc.append(variableName);
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode(variableName));
        }
        jsc.append(";");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return mArray;");
    }

    public void createGetByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("//-- check bounds for index");
        jsc.add("if ((index < 0) || (index > ");
        jsc.append(this.getName());
        jsc.append(".size())) {");
        jsc.indent();
        jsc.add("throw new IndexOutOfBoundsException();");
        jsc.unindent();
        jsc.add("}");
        jsc.add("");
        jsc.add("return ");
        String variableName = this.getName() + ".get(index)";
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.toString());
            jsc.append(") ");
            jsc.append(variableName);
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode(variableName));
        }
        jsc.append(";");
    }

    public void createGetCollectionReferenceMethod(JMethod method) {
        String cName = JavaNaming.toJavaMemberName(this.getElementName());
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Returns a reference to '");
        comment.appendComment(cName);
        comment.appendComment("'.");
        comment.appendComment(" No type checking is performed on any ");
        comment.appendComment("modications to the Collection.");
        JDocDescriptor jDesc = JDocDescriptor.createReturnDesc();
        jDesc.setDescription("returns a reference to the Collection.");
        comment.addDescriptor(jDesc);
        JSourceCode jsc = method.getSourceCode();
        jsc.add("return ");
        jsc.append(this.getName() + ';');
    }

    public void createSetArrayMethod(JMethod method) {
        String index;
        JSourceCode jsc = method.getSourceCode();
        String paramName = method.getParameter(0).getName();
        if (paramName.equals(index = "i")) {
            index = "j";
        }
        jsc.add("//-- copy array");
        jsc.add(this.getName());
        jsc.append(".clear();");
        jsc.add("for (int ");
        jsc.append(index);
        jsc.append(" = 0; ");
        jsc.append(index);
        jsc.append(" < ");
        jsc.append(paramName);
        jsc.append(".length; ");
        jsc.append(index);
        jsc.append("++) {");
        jsc.indent();
        jsc.add(this.getName());
        jsc.append(".add(");
        jsc.append(this.getContentType().createToJavaObjectCode(paramName + '[' + index + ']'));
        jsc.append(");");
        jsc.unindent();
        jsc.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createSetByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("//-- check bounds for index");
        jsc.add("if ((index < 0) || (index > ");
        jsc.append(this.getName());
        jsc.append(".size())) {");
        jsc.indent();
        jsc.add("throw new IndexOutOfBoundsException();");
        jsc.unindent();
        jsc.add("}");
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize > 0) {
            jsc.add("if (!(");
            jsc.append("index < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException();");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".set(index, ");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createSetCollectionMethod(JMethod method) {
        String cName = JavaNaming.toJavaMemberName(this.getElementName());
        String paramName = method.getParameter(0).getName();
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Sets the value of '");
        comment.appendComment(cName);
        comment.appendComment("' by copying the given ArrayList.");
        JDocDescriptor jDesc = comment.getParamDescriptor(paramName);
        jDesc.setDescription("the ArrayList to copy.");
        JSourceCode jsc = method.getSourceCode();
        String index = "i";
        if (paramName.equals(index)) {
            index = "j";
        }
        jsc.add("//-- copy collection");
        jsc.add(this.getName());
        jsc.append(".clear();");
        jsc.add("for (int ");
        jsc.append(index);
        jsc.append(" = 0; ");
        jsc.append(index);
        jsc.append(" < ");
        jsc.append(paramName);
        jsc.append(".size(); ");
        jsc.append(index);
        jsc.append("++) {");
        jsc.indent();
        jsc.add(this.getName());
        jsc.append(".add(");
        jsc.append('(' + this.getContentType().getJType().toString() + ')');
        jsc.append(this.getContentType().createToJavaObjectCode(paramName + ".get(" + index + ')'));
        jsc.append(");");
        jsc.unindent();
        jsc.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createSetCollectionReferenceMethod(JMethod method) {
        String cName = JavaNaming.toJavaMemberName(this.getElementName());
        String paramName = method.getParameter(0).getName();
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Sets the value of '");
        comment.appendComment(cName);
        comment.appendComment("' by setting it to the given ArrayList.");
        comment.appendComment(" No type checking is performed.");
        JDocDescriptor jDesc = comment.getParamDescriptor(paramName);
        jDesc.setDescription("the ArrayList to copy.");
        JSourceCode jsc = method.getSourceCode();
        jsc.add(this.getName());
        jsc.append(" = ");
        jsc.append(paramName + ';');
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createRemoveMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("boolean removed = ");
        jsc.append(this.getName());
        jsc.append(".remove(");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
        jsc.add("return removed;");
    }

    public void createRemoveByObjectMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("boolean removed = ");
        jsc.append(this.getName());
        jsc.append(".remove(");
        jsc.append(this.getContentName());
        jsc.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
        jsc.add("return removed;");
    }

    public void createRemoveByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("java.lang.Object obj = ");
        jsc.append(this.getName());
        jsc.append(".get(index);");
        jsc.add(this.getName());
        jsc.append(".remove(index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
        jsc.add("return ");
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.getName());
            jsc.append(") obj;");
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode("obj"));
            jsc.append(";");
        }
    }

    public void createRemoveAllMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add(this.getName());
        jsc.append(".clear();");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createClearMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add(this.getName());
        jsc.append(".clear();");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }
}

