/*
 * Decompiled with CFR 0.152.
 */
package com.mindprod.csv;

import com.mindprod.common11.StringTools;
import com.mindprod.csv.CSVReader;
import com.mindprod.csv.ColumnDescriptor;
import com.mindprod.hunkio.HunkIO;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class CSVAlign {
    private static final String lineSeparator = "\r\n";
    private StringBuffer alignedLineBuffer;
    private int alignedLineWidth;
    private ColumnDescriptor[] colDescriptorArray;
    private ArrayList colDescriptorList;
    private int pending = -1;

    private void calcAlignedLineWidth() {
        this.alignedLineWidth = 0;
        int size = this.colDescriptorList.size();
        this.colDescriptorArray = this.colDescriptorList.toArray(new ColumnDescriptor[size]);
        this.colDescriptorList = null;
        for (int i = 0; i < this.colDescriptorArray.length; ++i) {
            this.alignedLineWidth += this.colDescriptorArray[i].maxWidth + 2;
        }
    }

    private void leftJustify(String field, char separator, int columnWidth) {
        if (this.pending >= 0) {
            this.alignedLineBuffer.append(',');
            for (int j = 0; j < this.pending; ++j) {
                this.alignedLineBuffer.append(' ');
            }
        }
        this.alignedLineBuffer.append(field);
        this.pending = columnWidth - field.length() + 1;
    }

    private void pass1(File file, char separator, char quote) throws IOException {
        CSVReader csv = new CSVReader(new FileReader(file), separator, quote, false, false);
        this.colDescriptorList = new ArrayList(40);
        try {
            block2: while (true) {
                String[] fields = csv.getAllFieldsInLine();
                int colIndex = 0;
                while (true) {
                    boolean isAwkward;
                    if (colIndex >= fields.length) continue block2;
                    if (colIndex >= this.colDescriptorList.size()) {
                        this.colDescriptorList.add(new ColumnDescriptor());
                    }
                    ColumnDescriptor col = (ColumnDescriptor)this.colDescriptorList.get(colIndex);
                    String field = fields[colIndex];
                    int width = field.length();
                    boolean bl = isAwkward = col.isAwkward || field.indexOf(separator) >= 0 || field.indexOf(quote) >= 0;
                    if (isAwkward) {
                        width += 2;
                        for (int i = 0; i < field.length(); ++i) {
                            if (field.charAt(i) != quote) continue;
                            ++width;
                        }
                    }
                    if (!col.isAwkward && isAwkward) {
                        col.isAwkward = true;
                        col.maxWidth += 2;
                    }
                    if (width > col.maxWidth) {
                        col.maxWidth = width;
                    }
                    if (!StringTools.isLegal(field, "0123456789.+-")) {
                        col.isNumeric = false;
                    }
                    ++colIndex;
                }
                break;
            }
        }
        catch (EOFException e) {
            csv.close();
            return;
        }
    }

    private void pass2(File file, char separator, char quote) throws IOException {
        CSVReader csv = new CSVReader(new FileReader(file), separator, quote, false, true);
        File tempFile = HunkIO.createTempFile("temp", ".tmp", file);
        BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
        try {
            while (true) {
                String[] fields = csv.getAllFieldsInLine();
                this.alignedLineBuffer = new StringBuffer(this.alignedLineWidth);
                this.pending = -1;
                for (int colIndex = 0; colIndex < fields.length; ++colIndex) {
                    ColumnDescriptor col = this.colDescriptorArray[colIndex];
                    String field = fields[colIndex];
                    if (col.isNumeric) {
                        this.rightJustify(field, separator, col.maxWidth);
                        continue;
                    }
                    if (col.isAwkward) {
                        field = CSVAlign.prepareAwkward(field, quote);
                    }
                    this.leftJustify(field, separator, col.maxWidth);
                }
                out.write(this.alignedLineBuffer.toString());
                out.write(lineSeparator);
            }
        }
        catch (EOFException e) {
            csv.close();
            out.close();
            file.delete();
            tempFile.renameTo(file);
            return;
        }
    }

    private void rightJustify(String field, char separator, int columnWidth) {
        if (this.pending >= 0) {
            this.alignedLineBuffer.append(',');
            for (int j = 0; j < this.pending; ++j) {
                this.alignedLineBuffer.append(' ');
            }
        }
        int spaces = columnWidth - field.length();
        for (int j = 0; j < spaces; ++j) {
            this.alignedLineBuffer.append(' ');
        }
        this.alignedLineBuffer.append(field);
        this.pending = 1;
    }

    public CSVAlign(File file, char separator, char quote) throws IOException {
        this.pass1(file, separator, quote);
        this.calcAlignedLineWidth();
        this.pass2(file, separator, quote);
    }

    private static String prepareAwkward(String s, char quote) {
        if (s.indexOf(quote) < 0) {
            return quote + s + quote;
        }
        StringBuffer sb = new StringBuffer(s.length() + 10);
        sb.append(quote);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == quote) {
                sb.append(quote);
                sb.append(quote);
                continue;
            }
            sb.append(c);
        }
        sb.append(quote);
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("CSVAlign needs a single filename.csv on the command line.");
        }
        String filename = args[0];
        if (!filename.endsWith(".csv")) {
            throw new IllegalArgumentException("CSVAlign needs a single filename.csv on the command line.");
        }
        try {
            new CSVAlign(new File(filename), ',', '\"');
        }
        catch (IOException e) {
            System.err.println("CSVAlign failed to align " + filename);
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

