/*
 * Decompiled with CFR 0.152.
 */
package com.mindprod.csv;

import com.mindprod.csv.CSVReader;
import com.mindprod.csv.CSVWriter;
import com.mindprod.hunkio.HunkIO;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class CSVPack {
    public CSVPack(File file, char separator, char quote) throws IOException {
        CSVReader in = new CSVReader(new FileReader(file), separator, quote, false, true);
        File tempFile = HunkIO.createTempFile("temp", ".tmp", file);
        CSVWriter out = new CSVWriter(new FileWriter(tempFile), 0, separator, quote, true);
        try {
            while (true) {
                String s = in.get();
                out.put(s);
            }
        }
        catch (EOFException e) {
            in.close();
            out.close();
            file.delete();
            tempFile.renameTo(file);
            return;
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("CSVPack needs a single filename.csv on the command line.");
        }
        String filename = args[0];
        if (!filename.endsWith(".csv")) {
            throw new IllegalArgumentException("CSVPack needs a single filename.csv on the command line.");
        }
        try {
            new CSVPack(new File(filename), ',', '\"');
        }
        catch (IOException e) {
            System.err.println("CSVPack failed to pack " + filename);
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

