/*
 * Decompiled with CFR 0.152.
 */
package com.mindprod.hunkio;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class HunkIO {
    public static File createTempFile(String prefix, String suffix, File near) throws IOException {
        if (near != null) {
            File dir;
            String parent;
            if (near.isDirectory()) {
                return File.createTempFile(prefix, suffix, near);
            }
            if (near.isFile() && (parent = near.getParent()) != null && (dir = new File(parent)).isDirectory()) {
                return File.createTempFile(prefix, suffix, dir);
            }
        }
        return File.createTempFile(prefix, suffix);
    }

    public static String readEntireFile(File fromFile) throws IOException {
        FileReader fr = new FileReader(fromFile);
        int size = (int)fromFile.length();
        char[] ca = new char[size];
        int charsRead = fr.read(ca);
        if (charsRead != size) {
            throw new IOException("error: problems reading file " + fromFile);
        }
        fr.close();
        return new String(ca);
    }

    public static String readEntireFile(String fromFile) throws IOException {
        return HunkIO.readEntireFile(new File(fromFile));
    }

    public static void writeEntireFile(File toFile, String text) throws IOException {
        FileWriter fw = new FileWriter(toFile);
        fw.write(text);
        fw.close();
    }

    public static void writeEntireFile(String toFile, String text) throws IOException {
        HunkIO.writeEntireFile(new File(toFile), text);
    }
}

