/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.binding;

import info.bix.tokai.bixpp.binding.Record;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;

public class RecordSet
implements Serializable {
    private static final long serialVersionUID = 4987295074566772815L;
    private ArrayList<Record> _recordList = new ArrayList();

    public void addRecord(Record vRecord) throws IndexOutOfBoundsException {
        Validate.notNull(vRecord);
        this._recordList.add(vRecord);
    }

    public void addRecord(int index, Record vRecord) throws IndexOutOfBoundsException {
        Validate.notNull(vRecord);
        this._recordList.add(index, vRecord);
    }

    public void clearRecord() {
        this._recordList.clear();
    }

    public Record getRecord(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._recordList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this._recordList.get(index);
    }

    public Record[] getRecord() {
        int size = this._recordList.size();
        Record[] mArray = new Record[size];
        int index = 0;
        while (index < size) {
            mArray[index] = this._recordList.get(index);
            ++index;
        }
        return mArray;
    }

    public int getRecordCount() {
        return this._recordList.size();
    }

    public boolean removeRecord(Record vRecord) {
        boolean removed = this._recordList.remove(vRecord);
        return removed;
    }

    public void setRecord(int index, Record vRecord) throws IndexOutOfBoundsException {
        Validate.notNull(vRecord);
        if (index < 0 || index > this._recordList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._recordList.set(index, vRecord);
    }

    public void setRecord(Record[] recordArray) {
        Validate.notNull(recordArray);
        this._recordList.clear();
        int i = 0;
        while (i < recordArray.length) {
            this._recordList.add(recordArray[i]);
            ++i;
        }
    }

    public Record getLastRecord() {
        return this.getRecord(this.getRecordCount() - 1);
    }

    public Record getRecordByDays(double days) {
        for (Record record : this._recordList) {
            if (record.getDays() != days) continue;
            return record;
        }
        return null;
    }
}

