/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.io;

import com.mindprod.csv.CSVReader;
import info.bix.tokai.bixpp.binding.BIXpp;
import info.bix.tokai.bixpp.binding.DataItem;
import info.bix.tokai.bixpp.binding.DefinitionItem;
import info.bix.tokai.bixpp.binding.DescriptionItem;
import info.bix.tokai.bixpp.binding.EventItem;
import info.bix.tokai.bixpp.binding.Image;
import info.bix.tokai.bixpp.binding.ImageItem;
import info.bix.tokai.bixpp.binding.Item;
import info.bix.tokai.bixpp.binding.Link;
import info.bix.tokai.bixpp.binding.RecordingDefinition;
import info.bix.tokai.bixpp.binding.Sound;
import info.bix.tokai.bixpp.binding.SoundItem;
import info.bix.tokai.bixpp.io.InputStreamCreator;
import info.bix.tokai.bixpp.utility.BIXppManager;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.lang.math.NumberUtils;

public class CSVImporter {
    private static final String SOUND = "Sound";
    private static final String IMAGE = "Image";
    private static final String EVENT = "Event";
    private static final String DESCRIPTION = "Description";
    private BIXpp existingBIXpp;
    private long minIndex = 1L;
    private boolean replaceItem = true;

    public CSVImporter() {
    }

    public CSVImporter(BIXpp bixpp) {
        this.existingBIXpp = bixpp;
    }

    public BIXpp importCSV(File csvFile) throws IOException {
        if (csvFile == null) {
            throw new IllegalArgumentException();
        }
        return this.importCSV(csvFile.toURL());
    }

    public BIXpp importCSV(URL csvURL) throws IOException {
        if (csvURL == null) {
            throw new IllegalArgumentException();
        }
        return this.importCSV(InputStreamCreator.openStream(csvURL));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BIXpp importCSV(InputStream csvStream) throws IOException {
        if (csvStream == null) {
            throw new IllegalArgumentException();
        }
        BIXpp bixpp = this.existingBIXpp;
        if (bixpp == null) {
            bixpp = new BIXpp();
        }
        CSVReader reader = null;
        try {
            try {
                void var7_9;
                void var6_8;
                void var5_7;
                BIXppManager manager = new BIXppManager(bixpp);
                reader = new CSVReader(new BufferedReader(new InputStreamReader(csvStream)), ',', '\"', true, true);
                String[] lines1 = reader.getAllFieldsInLine();
                String[] lines2 = reader.getAllFieldsInLine();
                String[] lines3 = reader.getAllFieldsInLine();
                int minHeader = NumberUtils.min(lines1.length, lines2.length, lines3.length);
                if (minHeader <= 0) {
                    BIXpp bIXpp = bixpp;
                    return bIXpp;
                }
                this.parseDate(bixpp, manager, (String[])var5_7, (String[])var6_8, (String[])var7_9);
                DefinitionItem[] defItems = this.createDefinitionItem(bixpp, manager, (String[])var5_7, (String[])var6_8, (String[])var7_9);
                this.parseItem(reader, manager, defItems);
                return bixpp;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (EOFException manager) {
            return bixpp;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public BIXpp getBixpp() {
        return this.existingBIXpp;
    }

    public void setBixpp(BIXpp bixpp) {
        this.existingBIXpp = bixpp;
    }

    public long getMinIndex() {
        return this.minIndex;
    }

    public void setMinIndex(long minIndex) {
        this.minIndex = minIndex;
    }

    public boolean isReplaceItem() {
        return this.replaceItem;
    }

    public void setReplaceItem(boolean replaceItem) {
        this.replaceItem = replaceItem;
    }

    private void parseDate(BIXpp bixpp, BIXppManager manager, String[] lines1, String[] lines2, String[] lines3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bixpp.getStart());
        try {
            int year = Integer.parseInt(lines1[0]);
            calendar.set(1, year);
        }
        catch (Exception year) {
            // empty catch block
        }
        try {
            int month = Integer.parseInt(lines2[0]);
            calendar.set(2, month - 1);
        }
        catch (Exception month) {
            // empty catch block
        }
        try {
            int day = Integer.parseInt(lines3[0]);
            calendar.set(5, day);
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.setStart(calendar.getTime());
    }

    private DefinitionItem[] createDefinitionItem(BIXpp bixpp, BIXppManager manager, String[] lines1, String[] lines2, String[] lines3) {
        DefinitionItem defItem;
        DefinitionItem[] defItems = new DefinitionItem[lines1.length - 1];
        int i = 0;
        while (i < defItems.length) {
            String name = lines1[i + 1];
            String type = lines2[i + 1];
            if (!name.equals("")) {
                if (type.equals(EVENT)) {
                    defItem = new EventItem();
                } else if (type.equals(IMAGE)) {
                    defItem = new ImageItem();
                } else if (type.equals(SOUND)) {
                    defItem = new SoundItem();
                } else if (type.equals(DESCRIPTION)) {
                    defItem = new DescriptionItem();
                } else {
                    defItem = new DataItem();
                    ((DataItem)defItem).setUnit(type);
                }
                defItem.setName(name);
                if (i < lines3.length - 1 && !lines3[i + 1].equals("")) {
                    defItem.setComment(lines3[i + 1]);
                }
                defItems[i] = defItem;
            }
            ++i;
        }
        RecordingDefinition rd = bixpp.getRecordingDefinition();
        long index = this.minIndex;
        DefinitionItem[] definitionItemArray = defItems;
        int n = 0;
        int n2 = definitionItemArray.length;
        while (n < n2) {
            defItem = definitionItemArray[n];
            if (defItem != null) {
                if (this.replaceItem) {
                    if (rd.getDefinitionItemCount() <= 0) {
                        index = manager.getEmptyIndex(index);
                        defItem.setIndex(index);
                        rd.addDefinitionItem(defItem);
                        ++index;
                    } else {
                        int i2 = 0;
                        while (i2 < rd.getDefinitionItemCount()) {
                            DefinitionItem defItem2 = rd.getDefinitionItem(i2);
                            if (defItem.getName().equals(defItem2.getName()) && defItem.getClass().isInstance(defItem2)) {
                                defItem.setIndex(defItem2.getIndex());
                                rd.setDefinitionItem(i2, defItem);
                                break;
                            }
                            if (i2 == rd.getDefinitionItemCount() - 1) {
                                index = manager.getEmptyIndex(index);
                                defItem.setIndex(index);
                                rd.addDefinitionItem(defItem);
                                ++index;
                            }
                            ++i2;
                        }
                    }
                } else {
                    index = manager.getEmptyIndex(index);
                    defItem.setIndex(index);
                    rd.addDefinitionItem(defItem);
                    ++index;
                }
            }
            ++n;
        }
        return defItems;
    }

    /*
     * Unable to fully structure code
     */
    private void parseItem(CSVReader reader, BIXppManager manager, DefinitionItem[] defItems) throws EOFException, IOException {
        block6: while (true) {
            if ((line = reader.getAllFieldsInLine()).length <= 0) {
                continue;
            }
            try {
                days = Integer.parseInt(line[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (days < 0) continue;
            min = Math.min(line.length - 1, defItems.length);
            i = 0;
            while (true) {
                block16: {
                    if (i < min) ** break;
                    continue block6;
                    try {
                        block17: {
                            defItem = defItems[i];
                            data = line[i + 1];
                            if (defItem == null) break block16;
                            if (data.equals("")) {
                                manager.deleteItem(days, defItem.getIndex());
                                break block16;
                            }
                            item = new Item();
                            item.setIndex(defItem.getIndex());
                            if (defItem instanceof DataItem) {
                                try {
                                    value = Double.parseDouble(data);
                                    item.setValue(value);
                                    break block17;
                                }
                                catch (Exception e) {
                                    manager.deleteItem(days, defItem.getIndex());
                                    break block16;
                                }
                            }
                            if (defItem instanceof ImageItem) {
                                image = new Image();
                                link = new Link();
                                link.setURI(data);
                                image.setLink(link);
                                item.setImage(image);
                            } else if (defItem instanceof SoundItem) {
                                sound = new Sound();
                                link = new Link();
                                link.setURI(data);
                                sound.setLink(link);
                                item.setSound(sound);
                            } else if (defItem instanceof DescriptionItem) {
                                item.setDescription(data);
                            }
                        }
                        manager.setItem(days, defItem.getIndex(), item);
                    }
                    catch (Exception var8_10) {
                        // empty catch block
                    }
                }
                ++i;
            }
            break;
        }
    }
}

