/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.utility;

import info.bix.tokai.bixpp.binding.BIXpp;
import info.bix.tokai.bixpp.binding.DefinitionItem;
import info.bix.tokai.bixpp.binding.Item;
import info.bix.tokai.bixpp.binding.Record;
import info.bix.tokai.bixpp.binding.RecordSet;
import info.bix.tokai.bixpp.binding.RecordingDefinition;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public class BIXppManager {
    private BIXpp bixpp;

    public BIXppManager(BIXpp bixpp) {
        this.setBixpp(bixpp);
    }

    public BIXpp getBixpp() {
        return this.bixpp;
    }

    public void setBixpp(BIXpp bixpp) {
        if (bixpp == null) {
            throw new IllegalArgumentException();
        }
        this.bixpp = bixpp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStart(Date start) {
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            Record[] records;
            if (this.bixpp.getStart().equals(start)) {
                return;
            }
            double days = this.getDays(start);
            Record[] recordArray = records = this.bixpp.getRecordSet().getRecord();
            int n = 0;
            int n2 = recordArray.length;
            while (n < n2) {
                Record record = recordArray[n];
                record.setDays(record.getDays() - days);
                ++n;
            }
            this.bixpp.setStart(start);
        }
    }

    public double getDays(Date date) {
        Date date2 = DateUtils.truncate(date, 5);
        Date start = DateUtils.truncate(this.bixpp.getStart(), 5);
        double result = (date2.getTime() - start.getTime()) / 1000L / 60L / 60L / 24L;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEmptyIndex(long minIndex) {
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            long index = minIndex;
            while (!this.isEmptyIndex(index)) {
                ++index;
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEmptyIndex(long index) {
        if (index < 0L) {
            return false;
        }
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            Object[] objectArray = this.bixpp.getRecordingDefinition().getDefinitionItem();
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                DefinitionItem rdItem = objectArray[n];
                if (rdItem.getIndex() == index) {
                    return false;
                }
                ++n;
            }
            objectArray = this.bixpp.getRecordSet().getRecord();
            n = 0;
            n2 = objectArray.length;
            while (n < n2) {
                Object record = objectArray[n];
                Item[] itemArray = ((Record)record).getItem();
                int n3 = 0;
                int n4 = itemArray.length;
                while (n3 < n4) {
                    Item item = itemArray[n3];
                    if (item.getIndex() == index) {
                        return false;
                    }
                    ++n3;
                }
                ++n;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item[] getItem(long index) {
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            int lastDays = (int)this.getLastDays();
            if (lastDays < 0) {
                return new Item[0];
            }
            Item[] items = new Item[lastDays + 1];
            RecordSet rs = this.bixpp.getRecordSet();
            int days = 0;
            Record[] recordArray = rs.getRecord();
            int n = 0;
            int n2 = recordArray.length;
            while (n < n2) {
                Record record = recordArray[n];
                days = (int)record.getDays();
                if (days >= 0) {
                    Item[] itemArray = record.getItem();
                    int n3 = 0;
                    int n4 = itemArray.length;
                    while (n3 < n4) {
                        Item item = itemArray[n3];
                        if (item.getIndex() == index) {
                            items[days] = item;
                            break;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(double days, long index, Item item) {
        if (index < 0L) {
            return;
        }
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            Record record;
            if (item != null) {
                item.setIndex(index);
            }
            if ((record = this.getRecord(days)) != null) {
                int i = 0;
                while (i < record.getItemCount()) {
                    if (record.getItem(i).getIndex() == index) {
                        if (item != null) {
                            record.setItem(i, item);
                        } else {
                            record.removeItem(record.getItem(i));
                            if (record.getItemCount() <= 0) {
                                this.bixpp.getRecordSet().removeRecord(record);
                            }
                        }
                        return;
                    }
                    ++i;
                }
                if (item != null) {
                    record.addItem(item);
                }
                return;
            }
            if (item == null) {
                return;
            }
            record = new Record();
            record.setDays(days);
            item.setIndex(index);
            record.addItem(item);
            RecordSet recordSet = this.bixpp.getRecordSet();
            if (recordSet.getRecordCount() <= 0) {
                recordSet.addRecord(record);
                return;
            }
            int i = 0;
            while (i < recordSet.getRecordCount()) {
                if (days < recordSet.getRecord(i).getDays()) {
                    recordSet.addRecord(i, record);
                    return;
                }
                ++i;
            }
            recordSet.addRecord(record);
        }
    }

    public void deleteItem(double days, long index) {
        Record record = this.getRecord(days);
        if (record != null) {
            int i = 0;
            while (i < record.getItemCount()) {
                if (record.getItem(i).getIndex() == index) {
                    record.removeItem(record.getItem(i));
                    if (record.getItemCount() <= 0) {
                        this.bixpp.getRecordSet().removeRecord(record);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record getRecord(double days) {
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            RecordSet rs = this.bixpp.getRecordSet();
            if (rs != null) {
                Record[] recordArray = rs.getRecord();
                int n = 0;
                int n2 = recordArray.length;
                while (n < n2) {
                    Record record = recordArray[n];
                    if (record.getDays() == days) {
                        return record;
                    }
                    ++n;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinitionItem getDefinitionItem(long index) {
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            RecordingDefinition rd = this.bixpp.getRecordingDefinition();
            DefinitionItem[] definitionItemArray = rd.getDefinitionItem();
            int n = 0;
            int n2 = definitionItemArray.length;
            while (n < n2) {
                DefinitionItem rdItem = definitionItemArray[n];
                if (rdItem.getIndex() == index) {
                    return rdItem;
                }
                ++n;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLastDays() {
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            RecordSet recordSet = this.bixpp.getRecordSet();
            double days = Double.NEGATIVE_INFINITY;
            Record[] recordArray = recordSet.getRecord();
            int n = 0;
            int n2 = recordArray.length;
            while (n < n2) {
                Record record = recordArray[n];
                if (record.getDays() > days) {
                    days = record.getDays();
                }
                ++n;
            }
            return days;
        }
    }

    public void setItem(Date date, long index, Item item) {
        if (date == null || index < 0L) {
            return;
        }
        this.setItem(this.getDays(date), index, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeIndex(long oldIndex, long newIndex) {
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            block11: {
                block10: {
                    if (oldIndex >= 0L && newIndex >= 0L) break block10;
                    return false;
                }
                if (this.isEmptyIndex(newIndex)) break block11;
                return false;
            }
            Object[] objectArray = this.bixpp.getRecordingDefinition().getDefinitionItem();
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                DefinitionItem definitionItem = objectArray[n];
                if (definitionItem.getIndex() == oldIndex) {
                    definitionItem.setIndex(newIndex);
                    break;
                }
                ++n;
            }
            objectArray = this.bixpp.getRecordSet().getRecord();
            n = 0;
            n2 = objectArray.length;
            while (n < n2) {
                Object record = objectArray[n];
                Item[] itemArray = ((Record)record).getItem();
                int n3 = 0;
                int n4 = itemArray.length;
                while (n3 < n4) {
                    Item item = itemArray[n3];
                    if (item.getIndex() == oldIndex) {
                        item.setIndex(newIndex);
                    }
                    ++n3;
                }
                ++n;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefinitionItem(long index, DefinitionItem rdItem) {
        BIXpp bIXpp = this.bixpp;
        synchronized (bIXpp) {
            if (index < 0L) {
                return;
            }
            RecordingDefinition recordingDefinition = this.bixpp.getRecordingDefinition();
            DefinitionItem[] definitionItemArray = recordingDefinition.getDefinitionItem();
            int n = 0;
            int n2 = definitionItemArray.length;
            while (n < n2) {
                DefinitionItem rdItem_old = definitionItemArray[n];
                if (rdItem_old.getIndex() == index) {
                    recordingDefinition.removeDefinitionItem(rdItem_old);
                    break;
                }
                ++n;
            }
            if (rdItem != null) {
                rdItem.setIndex(index);
                recordingDefinition.addDefinitionItem(rdItem);
            }
        }
    }

    public Record getRecord(Date date) {
        return this.getRecord(this.getDays(date));
    }

    public Item getItem(Date date, long index) {
        Record record = this.getRecord(date);
        if (record != null) {
            Item[] itemArray = record.getItem();
            int n = 0;
            int n2 = itemArray.length;
            while (n < n2) {
                Item item = itemArray[n];
                if (item.getIndex() == index) {
                    return item;
                }
                ++n;
            }
        }
        return null;
    }

    public Item removeItem(Date date, long index) {
        Record record = this.getRecord(date);
        if (record != null) {
            int i = 0;
            while (i < record.getItemCount()) {
                Item item = record.getItem(i);
                if (item.getIndex() == index) {
                    record.removeItem(item);
                    return item;
                }
                ++i;
            }
        }
        return null;
    }
}

