/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.JarClassLoader;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Boot {
    public static final String BOOT_CLASS = "Boot-Class";
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String MAIN_JAR = "main/main.jar";
    public static final String WRAP_CLASS_LOADER = "Wrap-Class-Loader";
    public static final String WRAP_JAR = "/wrap/wraploader.jar";
    public static final String PROPERTY_PREFIX = "one-jar.";
    public static final String MAIN_CLASS = "one-jar.main-class";
    public static final String RECORD = "one-jar.record";
    public static final String JARNAMES = "one-jar.jar-names";
    public static final String VERBOSE = "one-jar.verbose";
    public static final String INFO = "one-jar.info";
    protected static boolean info;
    protected static boolean verbose;
    protected static JarClassLoader loader;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        loader = null;
    }

    public static JarClassLoader getClassLoader() {
        return loader;
    }

    protected static void VERBOSE(String message) {
        if (verbose) {
            System.out.println("Boot: " + message);
        }
    }

    protected static void WARNING(String message) {
        System.err.println("Boot: Warning: " + message);
    }

    protected static void INFO(String message) {
        if (info) {
            System.out.println("Boot: Info: " + message);
        }
    }

    public static void main(String[] args) throws Exception {
        Boot.run(args);
    }

    public static void run(String[] args) throws Exception {
        URL url;
        Class<?> clazz;
        Attributes attributes;
        Manifest manifest;
        InputStream is;
        String prefix = "Boot: ";
        String mainClass = null;
        String recording = null;
        boolean record = false;
        boolean jarnames = false;
        boolean verbose = false;
        Properties properties = new Properties();
        String props = "/one-jar.properties";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.simontuffs.onejar.Boot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz2.getResourceAsStream(props)) != null) {
            Boot.INFO("loading properties from " + props);
            properties.load(is);
        }
        props = "file:one-jar.properties";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("com.simontuffs.onejar.Boot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz3.getResourceAsStream(props)) != null) {
            Boot.INFO("loading properties from " + props);
            properties.load(is);
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (System.getProperty(name) != null) continue;
            System.setProperty(name, properties.getProperty(name));
        }
        mainClass = System.getProperty(MAIN_CLASS);
        if (System.getProperties().containsKey(RECORD)) {
            record = true;
            recording = System.getProperty(RECORD);
            if (recording.length() == 0) {
                recording = null;
            }
        }
        if (System.getProperties().containsKey(JARNAMES)) {
            record = true;
            jarnames = true;
        }
        if (System.getProperties().containsKey(VERBOSE)) {
            verbose = true;
        }
        if (System.getProperties().containsKey(INFO)) {
            info = true;
        }
        if (mainClass == null) {
            String jar = System.getProperty("java.class.path");
            JarFile jarFile = new JarFile(jar);
            manifest = jarFile.getManifest();
            attributes = manifest.getMainAttributes();
            mainClass = attributes.getValue(BOOT_CLASS);
        }
        if (mainClass == null) {
            InputStream is2;
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("com.simontuffs.onejar.Boot");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((is2 = clazz4.getResourceAsStream("/main/main.jar")) != null) {
                JarInputStream jis = new JarInputStream(is2);
                manifest = jis.getManifest();
                attributes = manifest.getMainAttributes();
                mainClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.simontuffs.onejar.Boot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((url = clazz.getResource(WRAP_JAR)) != null) {
            JarInputStream jis;
            String wrapLoader;
            JarClassLoader bootLoader = new JarClassLoader("wrap");
            bootLoader.setRecord(record);
            bootLoader.setFlatten(!jarnames);
            bootLoader.setRecording(recording);
            bootLoader.setInfo(info);
            bootLoader.setVerbose(verbose);
            bootLoader.load(null);
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("com.simontuffs.onejar.Boot");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wrapLoader = (jis = new JarInputStream(clazz5.getResourceAsStream(WRAP_JAR))).getManifest().getMainAttributes().getValue(WRAP_CLASS_LOADER)) == null) {
                Boot.WARNING(url + " did not contain a " + WRAP_CLASS_LOADER + " attribute, unable to load wrapping classloader");
            } else {
                Boot.INFO("using " + wrapLoader);
                Class<?> jarLoaderClass = bootLoader.loadClass(wrapLoader);
                Class[] classArray = new Class[1];
                Class<?> clazz6 = class$1;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$1 = Class.forName("java.lang.ClassLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz6;
                Constructor<?> ctor = jarLoaderClass.getConstructor(classArray);
                loader = (JarClassLoader)ctor.newInstance(bootLoader);
            }
        } else {
            Boot.INFO("using JarClassLoader");
            Class<?> clazz7 = class$0;
            if (clazz7 == null) {
                try {
                    clazz7 = class$0 = Class.forName("com.simontuffs.onejar.Boot");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            loader = new JarClassLoader(clazz7.getClassLoader());
        }
        loader.setRecord(record);
        loader.setFlatten(!jarnames);
        loader.setRecording(recording);
        loader.setInfo(info);
        loader.setVerbose(verbose);
        mainClass = loader.load(mainClass);
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> cls = loader.loadClass(mainClass);
        Class[] classArray = new Class[1];
        Class<?> clazz8 = class$2;
        if (clazz8 == null) {
            try {
                clazz8 = class$2 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz8;
        Method main = cls.getMethod("main", classArray);
        main.invoke(null, new Object[]{args});
    }
}

