/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.bixcomposite.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.BIXpp;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.DataItem;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.EventItem;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.Record;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateListener;

public class DetailPanel
extends JPanel
implements BixppOpenListener,
ChangeDateListener {
    Calendar calendar = new GregorianCalendar();
    private BIXpp bixpp;
    private JScrollPane jScrollPane = null;
    private JTextArea textArea = null;

    public DetailPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
        this.setSize(300, 200);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTextArea());
        }
        return this.jScrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
        }
        return this.textArea;
    }

    public void bixppOpened(BixppOpenEvent e) {
        this.bixpp = e.getBixpp();
    }

    public void recordIndexChanged(ChangeDateEvent e) {
        Record record = this.bixpp.getRecordSet().getRecord(e.getRecordIndex());
        int days = (int)record.getDays();
        this.calendar.setTime(this.bixpp.getStart().toDate());
        this.calendar.add(5, days);
        StringBuffer sb = new StringBuffer();
        sb.append("\u751f\u7523\u7d4c\u904e\u65e5\u6570 : " + days + " \u65e5" + "\n" + "\u65e5\u4ed8 : " + this.calendar.get(1) + "\u5e74" + (this.calendar.get(2) + 1) + "\u6708" + this.calendar.get(5) + "\u65e5\n\n");
        sb.append("\u74b0\u5883\u8a08\u6e2c\u30fb\u6210\u80b2\u60c5\u5831\n");
        DataItem[] dataItem = this.bixpp.getRecordingDefinition().getDataItem();
        int i = 0;
        while (i < dataItem.length) {
            int j = 0;
            while (j < record.getItemCount()) {
                if (record.getItem(j).getIndex() == dataItem[i].getIndex()) {
                    sb.append("  " + dataItem[i].getName() + " : " + record.getItem(j).getValue() + " " + dataItem[i].getUnit() + "\n");
                    break;
                }
                ++j;
            }
            ++i;
        }
        sb.append("\n\u683d\u57f9\u7ba1\u7406\u30fb\u4f5c\u696d\u60c5\u5831\n");
        EventItem[] eventItem = this.bixpp.getRecordingDefinition().getEventItem();
        int i2 = 0;
        while (i2 < eventItem.length) {
            int j = 0;
            while (j < record.getItemCount()) {
                if (record.getItem(j).getIndex() == eventItem[i2].getIndex()) {
                    sb.append("  " + eventItem[i2].getName());
                    if (eventItem[i2].getComment() != null) {
                        sb.append("\n    " + eventItem[i2].getComment());
                    }
                    sb.append("\n");
                    break;
                }
                ++j;
            }
            ++i2;
        }
        this.textArea.setText(sb.toString());
    }
}

