/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.bixenvironment;

import java.awt.Color;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class EnvironmentChartPanel
extends ChartPanel {
    private DateAxis dateDomainAxis;
    private ValueAxis daysDomainAxis;
    public static final int DAYS = 0;
    public static final int DATE = 1;
    private int style = 0;
    private XYSeriesCollection daysData;
    private TimeSeriesCollection dateData;
    private JFreeChart daysChart;
    private JFreeChart dateChart;
    private XYSeries daysSeries;
    private TimeSeries dateSeries;
    private Date startDate = new Date();
    private GregorianCalendar calendar = new GregorianCalendar();

    public EnvironmentChartPanel() {
        super(new JFreeChart(new XYPlot()));
        this.initialize();
        this.daysSeries = new XYSeries("");
        this.dateSeries = new TimeSeries("");
        this.daysData = new XYSeriesCollection(this.daysSeries);
        this.dateData = new TimeSeriesCollection(this.dateSeries);
        this.daysChart = ChartFactory.createXYLineChart("", "\u751f\u7523\u7d4c\u904e\u65e5\u6570", "", this.daysData, PlotOrientation.VERTICAL, false, true, false);
        this.dateChart = ChartFactory.createTimeSeriesChart("", "\u65e5\u4ed8", "", this.dateData, false, true, false);
        this.daysChart.setBackgroundPaint(SystemColor.control);
        this.dateChart.setBackgroundPaint(SystemColor.control);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.daysChart.setRenderingHints(hints);
        this.dateChart.setRenderingHints(hints);
        XYPlot plot = this.daysChart.getXYPlot();
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setInsets(new Insets(10, 10, 10, 10));
        StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPlotShapes(true);
        renderer.setSeriesPaint(0, Color.BLUE);
        this.daysDomainAxis = plot.getDomainAxis();
        this.daysDomainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setAutoRangeIncludesZero(false);
        plot = this.dateChart.getXYPlot();
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setInsets(new Insets(0, 0, 0, 0));
        renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPlotShapes(true);
        renderer.setSeriesPaint(0, Color.BLUE);
        this.dateDomainAxis = (DateAxis)plot.getDomainAxis();
        this.dateDomainAxis.setDateFormatOverride(new SimpleDateFormat("yy.MM.dd"));
        rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setAutoRangeMinimumSize(0.1);
        switch (this.style) {
            case 0: {
                this.setChart(this.daysChart);
                break;
            }
            case 1: {
                this.setChart(this.dateChart);
                break;
            }
            default: {
                this.setChart(this.daysChart);
            }
        }
        this.setMinimumDrawHeight(0);
        this.setMinimumDrawWidth(0);
        this.setMaximumDrawHeight(10000);
        this.setMaximumDrawWidth(10000);
    }

    private void initialize() {
    }

    public void setUnitLabel(String label) {
        this.daysChart.getXYPlot().getRangeAxis().setLabel(label);
        this.dateChart.getXYPlot().getRangeAxis().setLabel(label);
    }

    public void setTitle(String title) {
        this.daysChart.setTitle(title);
        this.dateChart.setTitle(title);
    }

    public void Init(String title, String label) {
        this.daysChart.setTitle(title);
        this.dateChart.setTitle(title);
        this.daysChart.getXYPlot().getRangeAxis().setLabel(label);
        this.dateChart.getXYPlot().getRangeAxis().setLabel(label);
        this.daysSeries.clear();
        this.dateSeries.clear();
    }

    public void setRange(Date start, int days) {
    }

    public void addData(double day, double value) {
        this.daysSeries.add(day, value);
        this.calendar.setTime(this.startDate);
        this.calendar.add(5, (int)day);
        this.dateSeries.addOrUpdate((RegularTimePeriod)new Day(this.calendar.getTime()), value);
    }

    public void changeDomainAxisStyle(int style) {
        this.style = style;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
}

