/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.common;

import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BIXppVersionChecker {
    private SAXParser saxParser;
    private DefaultHandler handler = this.createVersionCheckHandler();
    private double bixppVersion = 0.0;
    private boolean versionFlag = false;

    public BIXppVersionChecker() {
        try {
            this.saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getBIXppVersion(URI uri) {
        try {
            this.saxParser.parse(uri.toURL().openStream(), this.handler);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.bixppVersion;
    }

    private DefaultHandler createVersionCheckHandler() {
        DefaultHandler handler = new DefaultHandler(){

            public void characters(char[] ch, int start, int length) throws SAXException {
                super.characters(ch, start, length);
                if (BIXppVersionChecker.this.versionFlag) {
                    BIXppVersionChecker.this.bixppVersion = Double.parseDouble(new String(ch, start, length));
                }
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                super.startElement(uri, localName, qName, attributes);
                if (qName.equals("Version")) {
                    BIXppVersionChecker.this.versionFlag = true;
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                super.endElement(uri, localName, qName);
                if (qName.equals("Version")) {
                    BIXppVersionChecker.this.versionFlag = false;
                }
            }
        };
        return handler;
    }
}

