/*
 * Decompiled with CFR 0.152.
 */
package common.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private boolean resizeFlag = false;
    private Image bufferedImage;

    public void paint(Graphics g) {
        super.paint(g);
        if (this.bufferedImage != null) {
            g.drawImage(this.bufferedImage, 0, 0, this);
        }
    }

    public void setImage(BufferedImage bi) {
        if (this.resizeFlag) {
            this.bufferedImage = bi.getWidth() > this.getWidth() || bi.getHeight() > this.getHeight() ? bi.getScaledInstance(this.getWidth(), -1, 2) : bi;
        } else {
            this.setSize(new Dimension(bi.getWidth(), bi.getHeight()));
            this.setPreferredSize(new Dimension(bi.getWidth(), bi.getHeight()));
            this.bufferedImage = bi;
        }
    }

    public void setResize(boolean b) {
        this.resizeFlag = b;
    }

    public void clearImage() {
        this.bufferedImage = null;
        this.repaint();
    }
}

