/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer
extends BarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private boolean linkingLines = false;
    private transient double[] pointsRegister = null;

    public RangeType getRangeType() {
        return RangeType.STACKED;
    }

    public boolean hasLinkingLines() {
        return this.linkingLines;
    }

    public void setLinkingLines(boolean bl) {
        this.linkingLines = bl;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, Integer n, PlotRenderingInfo plotRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, n, plotRenderingInfo);
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            int n2 = categoryDataset.getColumnCount();
            double d2 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            double d3 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2);
            if (n2 > 0) {
                this.setBarWidth(d3 / (double)n2);
            } else {
                this.setBarWidth(d3);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        double d;
        Number number;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            number = categoryDataset.getValue(n3, n2);
            if (number != null) {
                d = number.doubleValue();
                if (d > 0.0) {
                    d2 += d;
                } else {
                    d3 += d;
                }
            }
            ++n3;
        }
        number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            double d4;
            double d5;
            double d6;
            d = number.doubleValue();
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            if (d > 0.0) {
                d6 = valueAxis.translateValueToJava2D(d2, rectangle2D, rectangleEdge);
                d5 = valueAxis.translateValueToJava2D(d2 + d, rectangle2D, rectangleEdge);
                d4 = Math.min(d6, d5);
            } else {
                d6 = valueAxis.translateValueToJava2D(d3, rectangle2D, rectangleEdge);
                d5 = valueAxis.translateValueToJava2D(d3 + d, rectangle2D, rectangleEdge);
                d4 = Math.min(d6, d5);
            }
            double d7 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d8 = Math.abs(d5 - d6);
            double d9 = this.getBarWidth();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d7, d8, d9);
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.isDrawBarOutline() && this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
                if (categoryItemLabelGenerator != null) {
                    string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Paint paint = this.getItemPaint(n, n2);
        if (this.hasLinkingLines() && this.pointsRegister == null) {
            this.pointsRegister = new double[categoryDataset.getColumnCount() * categoryDataset.getRowCount() * 2];
        }
        double d = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            Number number = categoryDataset.getValue(n3, n2);
            if (number != null) {
                double d4 = number.doubleValue();
                if (d4 > 0.0) {
                    d2 += d4;
                } else {
                    d3 += d4;
                }
            }
            ++n3;
        }
        boolean bl = false;
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            Object object;
            double d5;
            double d6;
            double d7;
            double d8 = number.doubleValue();
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            if (d8 > 0.0) {
                d7 = valueAxis.translateValueToJava2D(d2, rectangle2D, rectangleEdge);
                d6 = valueAxis.translateValueToJava2D(d2 + d8, rectangle2D, rectangleEdge);
                d5 = Math.min(d7, d6);
                bl = true;
            } else {
                d7 = valueAxis.translateValueToJava2D(d3, rectangle2D, rectangleEdge);
                d6 = valueAxis.translateValueToJava2D(d3 + d8, rectangle2D, rectangleEdge);
                d5 = Math.min(d7, d6);
            }
            double d9 = this.getBarWidth();
            double d10 = Math.abs(d6 - d7);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d5, d9, d10);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.isDrawBarOutline() && this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if (this.hasLinkingLines()) {
                if (n2 == 0) {
                    this.pointsRegister[2 * n] = d + d9;
                    this.pointsRegister[2 * n + 1] = bl ? d5 : d5 + d10;
                } else {
                    double d11;
                    int n4 = n2 * categoryDataset.getRowCount() * 2 + 2 * n;
                    this.pointsRegister[n4] = d + d9;
                    if (bl) {
                        d11 = this.pointsRegister[n4 - 2 * categoryDataset.getRowCount()];
                        if (d11 > 0.0) {
                            object = new Line2D.Double(d, d5, d11, this.pointsRegister[n4 - 2 * categoryDataset.getRowCount() + 1]);
                            graphics2D.setPaint(Color.black);
                            graphics2D.draw((Shape)object);
                        }
                        this.pointsRegister[n4 + 1] = d5;
                    } else {
                        d11 = this.pointsRegister[n4 - 2 * categoryDataset.getRowCount()];
                        if (d11 > 0.0) {
                            object = new Line2D.Double(d, d5 + d10, d11, this.pointsRegister[n4 - 2 * categoryDataset.getRowCount() + 1]);
                            graphics2D.setPaint(Color.black);
                            graphics2D.draw((Shape)object);
                        }
                        this.pointsRegister[n4 + 1] = d5 + d10;
                    }
                }
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
                if (categoryItemLabelGenerator != null) {
                    string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                object = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    object = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, (String)object, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }
}

