/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisConstants;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.DatasetGroup;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Align;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;

public abstract class Plot
implements AxisChangeListener,
DatasetChangeListener,
AxisConstants,
Serializable,
Cloneable {
    public static final Number ZERO = new Integer(0);
    public static final Insets DEFAULT_INSETS = new Insets(4, 8, 4, 8);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final float DEFAULT_FOREGROUND_ALPHA = 1.0f;
    public static final float DEFAULT_BACKGROUND_ALPHA = 1.0f;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final int MINIMUM_WIDTH_TO_DRAW = 10;
    public static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    private Plot parent = null;
    private DatasetGroup datasetGroup;
    private String noDataMessage;
    private Font noDataMessageFont;
    private transient Paint noDataMessagePaint;
    private Insets insets;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint;
    private transient Image backgroundImage;
    private int backgroundImageAlignment = 15;
    private float foregroundAlpha;
    private float backgroundAlpha;
    private DrawingSupplier drawingSupplier;
    private transient EventListenerList listenerList;
    private double dataAreaRatio = 0.0;
    static /* synthetic */ Class class$org$jfree$chart$event$PlotChangeListener;

    protected Plot() {
        this.insets = new Insets(Plot.DEFAULT_INSETS.top, Plot.DEFAULT_INSETS.left, Plot.DEFAULT_INSETS.bottom, Plot.DEFAULT_INSETS.right);
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.backgroundAlpha = 1.0f;
        this.backgroundImage = null;
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.foregroundAlpha = 1.0f;
        this.noDataMessage = null;
        this.noDataMessageFont = new Font("SansSerif", 0, 12);
        this.noDataMessagePaint = Color.black;
        this.drawingSupplier = new DefaultDrawingSupplier();
        this.listenerList = new EventListenerList();
    }

    public DatasetGroup getDatasetGroup() {
        return this.datasetGroup;
    }

    protected void setDatasetGroup(DatasetGroup datasetGroup) {
        this.datasetGroup = datasetGroup;
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String string) {
        this.noDataMessage = string;
    }

    public Font getNoDataMessageFont() {
        return this.noDataMessageFont;
    }

    public void setNoDataMessageFont(Font font) {
        this.noDataMessageFont = font;
    }

    public Paint getNoDataMessagePaint() {
        return this.noDataMessagePaint;
    }

    public void setNoDataMessagePaint(Paint paint) {
        this.noDataMessagePaint = paint;
    }

    public abstract String getPlotType();

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(Plot plot) {
        this.parent = plot;
    }

    public Plot getRootPlot() {
        Plot plot = this.getParent();
        if (plot == null) {
            return this;
        }
        return plot.getRootPlot();
    }

    public boolean isSubplot() {
        return this.getParent() != null;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.setInsets(insets, true);
    }

    public void setInsets(Insets insets, boolean bl) {
        if (insets == null) {
            throw new NullPointerException("Plot.setInsets(..): Insets are null.");
        }
        if (!this.insets.equals(insets)) {
            this.insets = insets;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            if (this.backgroundPaint != null) {
                this.backgroundPaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.backgroundPaint != null && this.backgroundPaint.equals(paint)) {
                return;
            }
            this.backgroundPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float f) {
        if (this.backgroundAlpha != f) {
            this.backgroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        Plot plot = this.getParent();
        if (plot != null) {
            return plot.getDrawingSupplier();
        }
        drawingSupplier = this.drawingSupplier;
        return drawingSupplier;
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        this.drawingSupplier = drawingSupplier;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getBackgroundImageAlignment() {
        return this.backgroundImageAlignment;
    }

    public void setBackgroundImageAlignment(int n) {
        if (this.backgroundImageAlignment != n) {
            this.backgroundImageAlignment = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            if (this.outlineStroke != null) {
                this.outlineStroke = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlineStroke != null && this.outlineStroke.equals(stroke)) {
                return;
            }
            this.outlineStroke = stroke;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            if (this.outlinePaint != null) {
                this.outlinePaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlinePaint != null && this.outlinePaint.equals(paint)) {
                return;
            }
            this.outlinePaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float f) {
        if (this.foregroundAlpha != f) {
            this.foregroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void addChangeListener(PlotChangeListener plotChangeListener) {
        this.listenerList.add(class$org$jfree$chart$event$PlotChangeListener == null ? (class$org$jfree$chart$event$PlotChangeListener = Plot.class$("org.jfree.chart.event.PlotChangeListener")) : class$org$jfree$chart$event$PlotChangeListener, plotChangeListener);
    }

    public void removeChangeListener(PlotChangeListener plotChangeListener) {
        this.listenerList.remove(class$org$jfree$chart$event$PlotChangeListener == null ? (class$org$jfree$chart$event$PlotChangeListener = Plot.class$("org.jfree.chart.event.PlotChangeListener")) : class$org$jfree$chart$event$PlotChangeListener, plotChangeListener);
    }

    public void notifyListeners(PlotChangeEvent plotChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$jfree$chart$event$PlotChangeListener == null ? Plot.class$("org.jfree.chart.event.PlotChangeListener") : class$org$jfree$chart$event$PlotChangeListener)) {
                ((PlotChangeListener)objectArray[n + 1]).plotChanged(plotChangeEvent);
            }
            n -= 2;
        }
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, PlotRenderingInfo var3);

    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Composite composite;
        if (this.backgroundPaint != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
            graphics2D.setComposite(composite);
        }
        if (this.backgroundImage != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(2, this.backgroundAlpha));
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
            Align.align(double_, rectangle2D, this.backgroundImageAlignment);
            graphics2D.drawImage(this.backgroundImage, (int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth() + 1, (int)((RectangularShape)double_).getHeight() + 1, null);
            graphics2D.setComposite(composite);
        }
    }

    public void drawOutline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.outlineStroke != null && this.outlinePaint != null) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(rectangle2D);
        }
    }

    protected void drawNoDataMessage(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        String string = this.noDataMessage;
        if (string != null) {
            graphics2D.setFont(this.noDataMessageFont);
            graphics2D.setPaint(this.noDataMessagePaint);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D2 = this.noDataMessageFont.getStringBounds(string, fontRenderContext);
            float f = (float)(rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - rectangle2D2.getWidth() / 2.0);
            float f2 = (float)(rectangle2D.getMinY() + rectangle2D.getHeight() / 2.0 - rectangle2D2.getHeight() / 2.0);
            graphics2D.drawString(string, f, f2);
        }
        graphics2D.clip(shape);
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
    }

    public void zoom(double d) {
    }

    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        this.notifyListeners(plotChangeEvent);
    }

    protected double getRectX(double d, double d2, double d3, RectangleEdge rectangleEdge) {
        double d4 = d;
        if (rectangleEdge == RectangleEdge.LEFT) {
            d4 += d2;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            d4 += d3;
        }
        return d4;
    }

    protected double getRectY(double d, double d2, double d3, RectangleEdge rectangleEdge) {
        double d4 = d;
        if (rectangleEdge == RectangleEdge.TOP) {
            d4 += d2;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            d4 += d3;
        }
        return d4;
    }

    public double getDataAreaRatio() {
        return this.dataAreaRatio;
    }

    public void setDataAreaRatio(double d) {
        this.dataAreaRatio = d;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Plot) {
            Plot plot = (Plot)object;
            boolean bl = ObjectUtils.equal(this.noDataMessage, plot.noDataMessage);
            boolean bl2 = ObjectUtils.equal(this.noDataMessageFont, plot.noDataMessageFont);
            boolean bl3 = ObjectUtils.equal(this.noDataMessagePaint, plot.noDataMessagePaint);
            boolean bl4 = ObjectUtils.equal(this.insets, plot.insets);
            boolean bl5 = ObjectUtils.equal(this.outlineStroke, plot.outlineStroke);
            boolean bl6 = ObjectUtils.equal(this.outlinePaint, plot.outlinePaint);
            boolean bl7 = ObjectUtils.equal(this.backgroundPaint, plot.backgroundPaint);
            boolean bl8 = ObjectUtils.equal(this.backgroundImage, plot.backgroundImage);
            boolean bl9 = this.backgroundImageAlignment == plot.backgroundImageAlignment;
            boolean bl10 = this.foregroundAlpha == plot.foregroundAlpha;
            boolean bl11 = this.backgroundAlpha == plot.backgroundAlpha;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Plot plot = (Plot)super.clone();
        plot.datasetGroup = (DatasetGroup)ObjectUtils.clone(this.datasetGroup);
        plot.drawingSupplier = (DrawingSupplier)ObjectUtils.clone(this.drawingSupplier);
        plot.listenerList = new EventListenerList();
        return plot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.noDataMessagePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.noDataMessagePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.listenerList = new EventListenerList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RectangleEdge resolveDomainAxisLocation(AxisLocation axisLocation, PlotOrientation plotOrientation) {
        RectangleEdge rectangleEdge = null;
        if (axisLocation == AxisLocation.TOP_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                return RectangleEdge.RIGHT;
            }
            if (plotOrientation != PlotOrientation.VERTICAL) throw new IllegalStateException("XYPlot.resolveDomainAxisLocation(...)");
            return RectangleEdge.TOP;
        }
        if (axisLocation == AxisLocation.TOP_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                return RectangleEdge.LEFT;
            }
            if (plotOrientation != PlotOrientation.VERTICAL) throw new IllegalStateException("XYPlot.resolveDomainAxisLocation(...)");
            return RectangleEdge.TOP;
        }
        if (axisLocation == AxisLocation.BOTTOM_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                return RectangleEdge.RIGHT;
            }
            if (plotOrientation != PlotOrientation.VERTICAL) throw new IllegalStateException("XYPlot.resolveDomainAxisLocation(...)");
            return RectangleEdge.BOTTOM;
        }
        if (axisLocation != AxisLocation.BOTTOM_OR_LEFT) return rectangleEdge;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            return RectangleEdge.LEFT;
        }
        if (plotOrientation != PlotOrientation.VERTICAL) throw new IllegalStateException("XYPlot.resolveDomainAxisLocation(...)");
        return RectangleEdge.BOTTOM;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RectangleEdge resolveRangeAxisLocation(AxisLocation axisLocation, PlotOrientation plotOrientation) {
        RectangleEdge rectangleEdge = null;
        if (axisLocation == AxisLocation.TOP_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                return RectangleEdge.TOP;
            }
            if (plotOrientation != PlotOrientation.VERTICAL) throw new IllegalStateException("XYPlot.resolveDomainAxisLocation(...)");
            return RectangleEdge.RIGHT;
        }
        if (axisLocation == AxisLocation.TOP_OR_LEFT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                return RectangleEdge.TOP;
            }
            if (plotOrientation != PlotOrientation.VERTICAL) throw new IllegalStateException("XYPlot.resolveDomainAxisLocation(...)");
            return RectangleEdge.LEFT;
        }
        if (axisLocation == AxisLocation.BOTTOM_OR_RIGHT) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                return RectangleEdge.BOTTOM;
            }
            if (plotOrientation != PlotOrientation.VERTICAL) throw new IllegalStateException("XYPlot.resolveDomainAxisLocation(...)");
            return RectangleEdge.RIGHT;
        }
        if (axisLocation != AxisLocation.BOTTOM_OR_LEFT) return rectangleEdge;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            return RectangleEdge.BOTTOM;
        }
        if (plotOrientation != PlotOrientation.VERTICAL) throw new IllegalStateException("XYPlot.resolveDomainAxisLocation(...)");
        return RectangleEdge.LEFT;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

