/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

public class AreaXYRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotArea;
    private boolean showOutline;
    protected transient Line2D line;
    protected transient Polygon pArea = null;

    public AreaXYRenderer() {
        this(4);
    }

    public AreaXYRenderer(int n) {
        this(n, null, null);
    }

    public AreaXYRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (n == 4) {
            this.plotArea = true;
        }
        if (n == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public int initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
        return 1;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        Object object;
        Object object2;
        int n4 = xYDataset.getItemCount(n);
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        if (n2 == 0) {
            this.pArea = new Polygon();
            double d3 = valueAxis2.translateValueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.pArea.addPoint((int)d, (int)d3);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d3, (int)d);
            }
        }
        if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
            this.pArea.addPoint((int)d, (int)d2);
        } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            this.pArea.addPoint((int)d2, (int)d);
        }
        Shape shape = null;
        if (this.plotShapes) {
            shape = this.getItemShape(n, n2);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                shape = this.createTransformedShape(shape, d, d2);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                shape = this.createTransformedShape(shape, d2, d);
            }
            graphics2D.draw(shape);
        } else if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
            shape = new Rectangle2D.Double(d - 2.0, d2 - 2.0, 4.0, 4.0);
        } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            shape = new Rectangle2D.Double(d2 - 2.0, d - 2.0, 4.0, 4.0);
        }
        if (this.plotLines && n2 > 0) {
            object2 = xYDataset.getXValue(n, n2 - 1);
            object = xYDataset.getYValue(n, n2 - 1);
            double d4 = valueAxis.translateValueToJava2D(((Number)object2).doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
            double d5 = valueAxis2.translateValueToJava2D(((Number)object).doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.line.setLine(d4, d5, d, d2);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                this.line.setLine(d5, d4, d2, d);
            }
            graphics2D.draw(this.line);
        }
        if (this.plotArea && n2 > 0 && n2 == n4 - 1) {
            double d6 = valueAxis2.translateValueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.pArea.addPoint((int)d, (int)d6);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d6, (int)d);
            }
            graphics2D.fill(this.pArea);
            if (this.showOutline) {
                graphics2D.setStroke(xYPlot.getOutlineStroke());
                graphics2D.setPaint(xYPlot.getOutlinePaint());
                graphics2D.draw(this.pArea);
            }
        }
        if (xYPlot.isDomainCrosshairLockedOnData()) {
            if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue(), d, d2);
            } else {
                crosshairInfo.updateCrosshairX(number.doubleValue());
            }
        } else if (xYPlot.isRangeCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(number2.doubleValue());
        }
        if (this.getInfo() != null && (object2 = this.getInfo().getOwner().getEntityCollection()) != null && shape != null) {
            object = null;
            if (this.getToolTipGenerator() != null) {
                object = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            if (this.getURLGenerator() != null) {
                string = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n, n2, (String)object, string);
            object2.addEntity(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

