/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xml;

import org.jfree.data.xml.CategorySeriesHandler;
import org.jfree.data.xml.DatasetTags;
import org.jfree.data.xml.KeyHandler;
import org.jfree.data.xml.PieDatasetHandler;
import org.jfree.data.xml.RootHandler;
import org.jfree.data.xml.ValueHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ItemHandler
extends DefaultHandler
implements DatasetTags {
    private RootHandler root;
    private DefaultHandler parent;
    private Comparable key;
    private Number value;

    public ItemHandler(RootHandler rootHandler, DefaultHandler defaultHandler) {
        this.root = rootHandler;
        this.parent = defaultHandler;
        this.key = null;
        this.value = null;
    }

    public Comparable getKey() {
        return this.getKey();
    }

    public void setKey(Comparable comparable) {
        this.key = comparable;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number number) {
        this.value = number;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("Item")) {
            KeyHandler keyHandler = new KeyHandler(this.root, this);
            this.root.pushSubHandler(keyHandler);
        } else if (string3.equals("Value")) {
            ValueHandler valueHandler = new ValueHandler(this.root, this);
            this.root.pushSubHandler(valueHandler);
        } else {
            throw new SAXException("Expected <Item> or <Value>...found " + string3);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.parent instanceof PieDatasetHandler) {
            PieDatasetHandler pieDatasetHandler = (PieDatasetHandler)this.parent;
            pieDatasetHandler.addItem(this.key, this.value);
            this.root.popSubHandler();
        } else if (this.parent instanceof CategorySeriesHandler) {
            CategorySeriesHandler categorySeriesHandler = (CategorySeriesHandler)this.parent;
            categorySeriesHandler.addItem(this.key, this.value);
            this.root.popSubHandler();
        }
    }
}

