/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.bixpp.EventItem;
import common.bixpp.Record;
import common.swing.BixPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.TimeSeriesToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class BixEventPanel
extends BixPanel {
    private JList list0;
    private JList list1;
    private JButton btn0;
    private JButton btn1;
    private Vector eventList0;
    private Vector eventList1;
    private DateAxis domainAxis;
    private NumberAxis rangeAxis;
    private TimeSeriesCollection data;
    private StandardLegend legend;
    private JLabel startLabel;
    static /* synthetic */ Class class$0;

    public BixEventPanel() {
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        this.data = new TimeSeriesCollection();
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"", (String)"\u65e5\u4ed8", (String)"", (XYDataset)this.data, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(700, 300));
        chartPanel.setPopupMenu(null);
        chartPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        XYPlot plot = chart.getXYPlot();
        plot.setRangeGridlinesVisible(false);
        StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPlotShapes(true);
        renderer.setShapesFilled(true);
        renderer.setPlotLines(false);
        renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        renderer.setSeriesPaint(1, (Paint)Color.CYAN);
        renderer.setSeriesPaint(2, (Paint)Color.LIGHT_GRAY);
        renderer.setSeriesPaint(3, (Paint)Color.GREEN);
        renderer.setSeriesPaint(4, (Paint)Color.MAGENTA);
        renderer.setSeriesPaint(5, (Paint)Color.ORANGE);
        renderer.setSeriesPaint(6, (Paint)Color.PINK);
        renderer.setSeriesPaint(7, (Paint)Color.RED);
        renderer.setSeriesPaint(8, (Paint)Color.GRAY);
        renderer.setSeriesPaint(9, (Paint)Color.DARK_GRAY);
        renderer.setSeriesPaint(10, (Paint)Color.BLACK);
        renderer.setShape((Shape)new RoundRectangle2D.Double(-10.0, -10.0, 20.0, 20.0, 5.0, 5.0));
        renderer.setToolTipGenerator((XYToolTipGenerator)new TimeSeriesToolTipGenerator((DateFormat)new SimpleDateFormat("yyyy.MM.dd EEEE"), (NumberFormat)new DecimalFormat(" ")));
        this.legend = (StandardLegend)chart.getLegend();
        this.domainAxis = (DateAxis)plot.getDomainAxis();
        this.domainAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yy.MM.dd  "));
        this.domainAxis.setAutoRange(true);
        this.domainAxis.setAutoTickUnitSelection(false);
        this.domainAxis.setVerticalTickLabels(true);
        this.domainAxis.setTickMarksVisible(false);
        this.rangeAxis = (NumberAxis)plot.getRangeAxis();
        this.rangeAxis.setVisible(false);
        this.rangeAxis.setAutoRangeIncludesZero(false);
        this.rangeAxis.setAutoRangeMinimumSize(0.1);
        this.rangeAxis.setUpperMargin(0.2);
        this.rangeAxis.setLowerMargin(1.0);
        JPanel selectPanel = new JPanel();
        selectPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Event Select"));
        GridBagLayout gb1 = new GridBagLayout();
        selectPanel.setLayout(gb1);
        this.list0 = new JList();
        JScrollPane scroll0 = new JScrollPane(this.list0);
        scroll0.setPreferredSize(new Dimension(200, 200));
        this.list1 = new JList();
        JScrollPane scroll1 = new JScrollPane(this.list1);
        scroll1.setPreferredSize(new Dimension(200, 200));
        this.btn0 = new JButton("\u2192");
        this.btn0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (BixEventPanel.this.list0.getSelectedIndex() < 0) {
                    return;
                }
                EventItem ei = (EventItem)BixEventPanel.this.list0.getSelectedValue();
                if (BixEventPanel.this.eventList1.size() == 0) {
                    BixEventPanel.this.eventList1.add(ei);
                    BixEventPanel.this.eventList0.remove(ei);
                } else {
                    int i = 0;
                    while (i < BixEventPanel.this.eventList1.size()) {
                        if (((EventItem)BixEventPanel.this.eventList1.get(i)).getIndex() > ei.getIndex()) {
                            BixEventPanel.this.eventList1.insertElementAt(ei, i);
                            BixEventPanel.this.eventList0.remove(ei);
                            break;
                        }
                        if (i == BixEventPanel.this.eventList1.size() - 1) {
                            BixEventPanel.this.eventList1.add(ei);
                            BixEventPanel.this.eventList0.remove(ei);
                            break;
                        }
                        ++i;
                    }
                }
                BixEventPanel.this.list0.setListData(BixEventPanel.this.eventList0);
                BixEventPanel.this.list1.setListData(BixEventPanel.this.eventList1);
                BixEventPanel.this.drawChart();
            }
        });
        this.btn1 = new JButton("\u2190");
        this.btn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (BixEventPanel.this.list1.getSelectedIndex() < 0) {
                    return;
                }
                EventItem ei = (EventItem)BixEventPanel.this.list1.getSelectedValue();
                if (BixEventPanel.this.eventList0.size() == 0) {
                    BixEventPanel.this.eventList0.add(ei);
                    BixEventPanel.this.eventList1.remove(ei);
                } else {
                    int i = 0;
                    while (i < BixEventPanel.this.eventList0.size()) {
                        if (((EventItem)BixEventPanel.this.eventList0.get(i)).getIndex() > ei.getIndex()) {
                            BixEventPanel.this.eventList0.insertElementAt(ei, i);
                            BixEventPanel.this.eventList1.remove(ei);
                            break;
                        }
                        if (i == BixEventPanel.this.eventList0.size() - 1) {
                            BixEventPanel.this.eventList0.add(ei);
                            BixEventPanel.this.eventList1.remove(ei);
                            break;
                        }
                        ++i;
                    }
                }
                BixEventPanel.this.list0.setListData(BixEventPanel.this.eventList0);
                BixEventPanel.this.list1.setListData(BixEventPanel.this.eventList1);
                BixEventPanel.this.drawChart();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridheight = 2;
        gb1.setConstraints(scroll0, c);
        selectPanel.add(scroll0);
        c.gridx = 2;
        gb1.setConstraints(scroll1, c);
        selectPanel.add(scroll1);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.insets = new Insets(80, 10, 0, 10);
        c.anchor = 15;
        gb1.setConstraints(this.btn0, c);
        selectPanel.add(this.btn0);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 11;
        gb1.setConstraints(this.btn1, c);
        selectPanel.add(this.btn1);
        this.startLabel = new JLabel("\u25cb\u25cb\u671f\u9593 :");
        c = new GridBagConstraints();
        c.gridy = 1;
        gb.setConstraints(this.startLabel, c);
        this.add(this.startLabel);
        c.gridy = 0;
        c.insets = new Insets(10, 10, 10, 10);
        gb.setConstraints((Component)chartPanel, c);
        this.add((Component)chartPanel);
        c.gridy = 2;
        gb.setConstraints(selectPanel, c);
        this.add(selectPanel);
        this.eventList0 = new Vector();
        this.eventList1 = new Vector();
    }

    public void parse() {
        this.eventList0.clear();
        this.eventList1.clear();
        int i = 0;
        while (i < this.bixpp.getRecordingDefinitionSize()) {
            if (this.bixpp.getRecordItem(i).getKind().equals("EventItem")) {
                this.eventList1.add(this.bixpp.getRecordItem(i));
            }
            ++i;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        StringBuffer b = new StringBuffer("\u25cb\u25cb\u671f\u9593 :");
        calendar.setTime(this.bixpp.getStartDate());
        b.append("" + calendar.get(1) + "." + calendar.get(2) + "." + calendar.get(5) + " - ");
        calendar.add(5, this.bixpp.getLastRecord().getDays());
        b.append("" + calendar.get(1) + "." + calendar.get(2) + "." + calendar.get(5));
        this.startLabel.setText(b.toString());
        calendar.add(5, 1);
        this.domainAxis.setRange(this.bixpp.getStartDate(), calendar.getTime());
        this.list0.setListData(this.eventList0);
        this.list1.setListData(this.eventList1);
        this.list0.setSelectedIndex(0);
        this.drawChart();
    }

    private void drawChart() {
        this.data.removeAllSeries();
        GregorianCalendar calendar = new GregorianCalendar();
        int i = 0;
        while (i < this.eventList1.size()) {
            int index = ((EventItem)this.eventList1.get(i)).getIndex();
            String string = ((EventItem)this.eventList1.get(i)).getName();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jfree.data.time.Day");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TimeSeries series = new TimeSeries(string, (Class)clazz);
            int j = 0;
            while (j < this.bixpp.getRecordSize()) {
                Record record = this.bixpp.getRecord(j);
                calendar.setTime(this.bixpp.getStartDate());
                int k = 0;
                while (k < record.size()) {
                    if (record.getItem(k).getIndex() == index) {
                        calendar.add(5, record.getDays());
                        series.add((RegularTimePeriod)new Day(calendar.getTime()), (double)(this.eventList1.size() - i));
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            this.data.addSeries(series);
            ++i;
        }
    }
}

